# 私有网盘助手

## 简介

这是一个Chrome扩展，用于解决私有网盘文件下载时的Cookie跨域问题。通过该扩展，用户可以直接从私有网盘服务器下载文件，而无需通过服务器中转，从而节省服务器带宽和提高下载速度。

## 功能特点

1. **绕过Cookie限制**：使用`chrome.cookies` API设置企业微信域名的Cookie
2. **直接下载**：文件直接从企业微信服务器下载到用户电脑
3. **节省服务器资源**：避免服务器中转，降低服务器负载
4. **提高下载速度**：用户直接从企业微信服务器下载，速度更快

## 安装方法

1. 打开Chrome浏览器，访问 `chrome://extensions/`
2. 开启右上角的"开发者模式"
3. 点击"加载已解压的扩展程序"
4. 选择本项目目录
5. 扩展安装完成

## 使用方法

1. 访问私有网盘文件列表页面
2. 点击文件下载按钮
3. 扩展会自动获取下载信息并打开弹窗
4. 在弹窗中点击"下载文件"按钮
5. 文件将直接从私有网盘服务器下载

## 技术实现

### 核心技术点

1. **manifest.json**：声明必要的权限
   - `cookies`：使用chrome.cookies API
   - `activeTab`：访问当前活动标签页
   - `host_permissions`：访问私有网盘域名

2. **内容脚本(content.js)**：
   - 监听页面中的下载按钮点击事件
   - 获取下载信息并发送到后台脚本

3. **后台脚本(background.js)**：
   - 接收来自内容脚本的消息
   - 存储下载信息供弹窗使用

4. **弹窗(popup.html/popup.js)**：
   - 显示下载状态
   - 使用chrome.cookies.set设置Cookie
   - 重定向到下载链接

## 注意事项

1. 需要根据实际的企业微信下载域名调整`host_permissions`
2. 下载信息的获取方式需要根据实际的服务器接口进行调整
3. Cookie的域名和路径需要根据企业微信的实际要求进行设置

## 文件结构

```
├── manifest.json          # 扩展配置文件
├── popup.html             # 弹窗页面
├── popup.js               # 弹窗逻辑
├── background.js          # 后台脚本
├── content.js             # 内容脚本
├── download.html          # 下载页面
├── download.js            # 下载页面逻辑
└── README.md              # 说明文档
```

## 开发建议

1. 在实际使用前，请确保已根据企业微信的实际API调整相关代码
2. 测试不同浏览器的兼容性
3. 考虑添加错误处理和用户友好的提示信息
4. 可以添加下载历史记录功能