// download.js - 下载页面逻辑

document.addEventListener('DOMContentLoaded', function() {
  const progressBar = document.getElementById('progressBar');
  const statusDiv = document.getElementById('status');
  const downloadBtn = document.getElementById('downloadBtn');
  
  // 模拟下载准备过程
  let progress = 0;
  const interval = setInterval(function() {
    progress += 5;
    progressBar.style.width = progress + '%';
    
    if (progress >= 100) {
      clearInterval(interval);
      statusDiv.className = 'status success';
      statusDiv.textContent = '文件准备完成，即将开始下载...';
      downloadBtn.disabled = false;
      downloadBtn.textContent = '立即下载';
      
      // 自动开始下载
      setTimeout(startDownload, 1000);
    }
  }, 100);
  
  // 下载按钮点击事件
  downloadBtn.addEventListener('click', startDownload);
  
  // 开始下载
  function startDownload() {
    // 这里应该是实际的下载逻辑
    // 在实际应用中，我们会在这里设置Cookie并重定向到下载链接
    
    statusDiv.textContent = '正在启动下载...';
    
    // 模拟下载过程
    setTimeout(function() {
      statusDiv.textContent = '下载已启动，请检查浏览器下载列表';
      downloadBtn.textContent = '下载已启动';
      downloadBtn.disabled = true;
      
      // 在实际应用中，这里会执行：
      // 1. 使用chrome.cookies.set设置Cookie
      // 2. 使用window.location.href或chrome.tabs.create重定向到下载链接
    }, 1000);
  }
});