// injected.js - 注入到页面的脚本

// 向页面暴露扩展已安装的标志
window.WeChatDownloadExtensionInstalled = true;

// 监听页面的消息
window.addEventListener('message', function(event) {
  // 确保消息来源是当前窗口
  if (event.source !== window) return;
  
  // 处理来自页面的下载请求
  if (event.data && event.data.type === 'WeChatDownloadRequest') {
    const fileid = event.data.fileid;
    
    if (fileid) {
      // 使用 CustomEvent 将消息传递给 content script
      window.postMessage({
        type: 'DOWNLOAD_REQUEST_FROM_PAGE',
        fileid: fileid
      }, '*');
    }
  }
  
  // 处理扩展检测请求
  if (event.data && event.data.type === 'CHECK_EXTENSION_INSTALLED') {
    // 回复扩展已安装
    window.postMessage({
      type: 'EXTENSION_INSTALLED_RESPONSE',
      installed: true
    }, '*');
  }
});