// popup.js - 弹窗逻辑

// 当弹窗加载时
document.addEventListener('DOMContentLoaded', function() {
  const downloadBtn = document.getElementById('downloadBtn');
  const statusDiv = document.getElementById('status');
  
  // 页面加载后立即检查是否有下载信息
  checkDownloadInfo();
  
  // 检查下载信息
  function checkDownloadInfo() {
    chrome.storage.local.get(['downloadInfo'], function(result) {
      if (result.downloadInfo) {
        statusDiv.className = 'status info';
        statusDiv.textContent = '检测到待下载文件: ' + result.downloadInfo.fileName;
        downloadBtn.disabled = false;
        downloadBtn.textContent = '开始下载';
      } else {
        // 尝试从后台获取当前下载信息
        chrome.runtime.sendMessage({ action: 'getCurrentDownloadInfo' }, function(response) {
          if (response.success && response.data) {
            statusDiv.className = 'status info';
            statusDiv.textContent = '检测到待下载文件: ' + response.data.fileName;
            downloadBtn.disabled = false;
            downloadBtn.textContent = '开始下载';
          } else {
            statusDiv.className = 'status error';
            statusDiv.textContent = '未检测到下载信息，请先在网页上点击下载按钮';
            downloadBtn.disabled = true;
            downloadBtn.textContent = '下载文件';
          }
        });
      }
    });
  }
  
  // 下载按钮点击事件
  downloadBtn.addEventListener('click', function() {
    // 从存储中获取下载信息
    chrome.storage.local.get(['downloadInfo'], function(result) {
      if (result.downloadInfo) {
        const downloadInfo = result.downloadInfo;
        
        // 设置Cookie并下载文件
        setCookieAndDownload(downloadInfo);
      } else {
        statusDiv.className = 'status error';
        statusDiv.textContent = '下载信息丢失，请重新尝试';
      }
    });
  });
  
  // 设置Cookie并下载文件
  function setCookieAndDownload(downloadInfo) {
    statusDiv.className = 'status info';
    statusDiv.textContent = '正在设置Cookie...';
    downloadBtn.disabled = true;
    
    try {
      console.log('设置Cookie，下载信息:', downloadInfo);
      
      // 使用chrome.cookies API设置Cookie
      chrome.cookies.set({
        url: downloadInfo.downloadUrl,
        name: downloadInfo.cookieName,
        value: downloadInfo.cookieValue,
        domain: downloadInfo.cookieDomain,
        path: '/',
        secure: true,
        httpOnly: false,
        expirationDate: Date.now() / 1000 + 60 // 60秒后过期
      }, function(cookie) {
        if (chrome.runtime.lastError) {
          console.error('设置Cookie失败:', chrome.runtime.lastError);
          statusDiv.className = 'status error';
          statusDiv.textContent = '设置Cookie失败: ' + chrome.runtime.lastError.message;
          downloadBtn.disabled = false;
        } else {
          console.log('Cookie设置成功:', cookie);
          statusDiv.className = 'status success';
          statusDiv.textContent = 'Cookie设置成功，正在开始下载...';
          
          // 短暂延迟后重定向到下载链接
          setTimeout(function() {
            chrome.tabs.create({ url: downloadInfo.downloadUrl });
            window.close(); // 关闭弹窗
          }, 1000);
        }
      });
    } catch (error) {
      console.error('设置Cookie时发生错误:', error);
      statusDiv.className = 'status error';
      statusDiv.textContent = '设置Cookie时发生错误: ' + error.message;
      downloadBtn.disabled = false;
    }
  }
});